<?php

namespace ZapperIntegration\Payments\Controller\Payments;

use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

class Cancel implements HttpGetActionInterface
{
    private ResultFactory $resultFactory;
    private Session $checkoutSession;
    private StoreManagerInterface $storeManager;

    /**
     * @param ResultFactory $resultFactory
     * @param Session $checkoutSession
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(ResultFactory $resultFactory, Session $checkoutSession, StoreManagerInterface $storeManager)
    {
        $this->resultFactory = $resultFactory;
        $this->checkoutSession = $checkoutSession;
        $this->storeManager = $storeManager;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface
     * @throws NoSuchEntityException
     */
    public function execute() : ResultInterface
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $store = $this->storeManager->getStore();
        $baseUrl = $store->getBaseUrl();
        $this->checkoutSession->restoreQuote();
        $response->setUrl($baseUrl . "checkout/cart");
        return $response;
    }
}
