<?php

namespace ZapperIntegration\Payments\Controller\Payments;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use ZapperIntegration\Payments\Model\PaymentHandler;
use ZapperIntegration\Payments\Model\ZapperConstants;

class Notification implements HttpGetActionInterface
{
    private PaymentHandler $paymentHandler;
    private ResultFactory $resultFactory;
    private RequestInterface $request;

    /**
     * @param PaymentHandler $paymentHandler
     * @param ResultFactory $resultFactory
     * @param RequestInterface $request
     */
    public function __construct(PaymentHandler $paymentHandler, ResultFactory $resultFactory, RequestInterface $request)
    {
        $this->paymentHandler = $paymentHandler;
        $this->resultFactory = $resultFactory;
        $this->request = $request;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface
     */
    public function execute() : ResultInterface
    {
        $zapperId = $this->request->getParam(ZapperConstants::ZAPPER_ID);
        $closureResult = $this->paymentHandler->HandlePayment($zapperId);

        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $response->setHttpResponseCode($closureResult == true ? 200 : 403);
        $response->setData($closureResult);
        return $response;
    }
}
