<?php

namespace ZapperIntegration\Payments\Model;

use Exception;
use Magento\Payment\Gateway\CommandInterface;
use Magento\Payment\Gateway\Data\OrderAdapterInterface;
use Magento\Payment\Gateway\Data\PaymentDataObjectInterface;
use Magento\Sales\Api\Data\OrderPaymentInterface;
use Magento\Sales\Api\Data\TransactionInterface;
use Magento\Sales\Api\OrderManagementInterface;
use Magento\Sales\Api\OrderPaymentRepositoryInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Api\TransactionRepositoryInterface;
use Magento\Sales\Model\Order\Payment\Transaction;

class InitializeCommand implements CommandInterface
{
    private const PAYMENT = 'payment';

    private OrderRepositoryInterface $orderRepository;
    private OrderPaymentRepositoryInterface $orderPaymentRepository;
    private OrderManagementInterface $orderManagementInterface;
    private TransactionRepositoryInterface $transactionRepository;
    private Transaction\BuilderInterface $transactionBuilder;

    public function execute(array $commandSubject)
    {
        /** @var PaymentDataObjectInterface $paymentDO */
        $paymentDO = $commandSubject[self::PAYMENT];

        // $payment = $paymentDO->getPayment();

//        $payment = $paymentDO->getPayment();
//        $orderId = $paymentDO->getOrder()->getId();
//
//        $order = $paymentDO->getOrder();



        // $payment->getMethodInstance()

//        $transaction = $this->transactionRepository->create();
//        $transaction->setOrderId($orderId);
//        $transaction->setPaymentId();

//        Transaction

        // https://developer.adobe.com/commerce/php/development/payments-integrations/payment-gateway/

    }

    function createTransaction($order = null, $paymentData = array())
    {
        try {
            //get payment object from order object
            $payment = $order->getPayment();
            $payment->setLastTransId($paymentData['id']);
            $payment->setTransactionId($paymentData['id']);
            $payment->setAdditionalInformation(
                [Transaction::RAW_DETAILS => (array) $paymentData]
            );
            $formattedPrice = $order->getBaseCurrency()->formatTxt(
                $order->getGrandTotal()
            );

            $message = __('The authorized amount is %1.', $formattedPrice);
            //get the object of builder class
            $trans = $this->transactionBuilder;
            $transaction = $trans->setPayment($payment)
                ->setOrder($order)
                ->setTransactionId($paymentData['zapperId'])
                ->setAdditionalInformation(
                    [Transaction::RAW_DETAILS => (array) $paymentData]
                )
                ->setFailSafe(true)
                //build method creates the transaction and returns the object
                ->build(TransactionInterface::TYPE_CAPTURE);

            $payment->addTransactionCommentsToOrder(
                $transaction,
                $message
            );
            $payment->setParentTransactionId(null);
            $payment->save();
            $order->save();

            $this->transactionRepository->save($transaction);
            return $transaction->getTransactionId();
        } catch (Exception $e) {
            //log errors here
        }
    }
}
