<?php

namespace ZapperIntegration\Payments\Model;

class UrlHelper
{
    public static function buildUrl(array $parts) : string {
        return implode('/', UrlHelper::stripSlashes($parts));
    }

    private static function stripSlashes(array $input) : array {
        return array_map(function($val) { return UrlHelper::stripSlash($val); }, $input);
    }

    private static function stripSlash(string $input) : string {
        preg_match('/^\/*(.+?)\/*$/', $input, $matches);
        return $matches[1];
    }
}
