<?php

namespace ZapperIntegration\Payments\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use ZapperIntegration\Payments\Model\ZapperApiInterface;
use ZapperIntegration\Payments\Model\ZapperConstants;

class BeforeSave implements ObserverInterface
{
    private ZapperApiInterface $zapperApi;
    private RequestInterface $request;
    private WriterInterface $configWriter;

    /**
     * @param RequestInterface $request
     */
    public function __construct(
        RequestInterface   $request,
        WriterInterface    $configWriter,
        ZapperApiInterface $zapperApi)
    {
        $this->request = $request;
        $this->configWriter = $configWriter;
        $this->zapperApi = $zapperApi;
    }


    public function execute(Observer $observer)
    {
        $groups = $this->request->getParam('groups');
        if (empty($groups)) {
            return $this;
        }

        $zapperPayments = $groups['ZapperIntegration_payments'];
        if (empty($zapperPayments)) {
            return $this;
        }

        $fields = $zapperPayments['fields'];
        if (empty($fields)) {
            return $this;
        }

        if (!array_key_exists(ZapperConstants::FORM_MERCHANT_ID, $fields)) {
            $this->configWriter->save(ZapperConstants::CONFIG_VERIFIED, "0");
            return $this;
        }

        if (!array_key_exists(ZapperConstants::FORM_MERCHANT_SITE_ID, $fields)) {
            $this->configWriter->save(ZapperConstants::CONFIG_VERIFIED, "0");
            return $this;
        }

        if (!array_key_exists(ZapperConstants::FORM_API_KEY, $fields)) {
            $this->configWriter->save(ZapperConstants::CONFIG_VERIFIED, "0");
            return $this;
        }

        $mid = $fields[ZapperConstants::FORM_MERCHANT_ID]['value'];
        $sid = $fields[ZapperConstants::FORM_MERCHANT_SITE_ID]['value'];
        $apiKey = $fields[ZapperConstants::FORM_API_KEY]['value'];

        $verified = $this->zapperApi->testCredentials($mid, $sid, $apiKey) ? "1" : "0";
        $this->configWriter->save(ZapperConstants::CONFIG_VERIFIED, $verified);

        return $this;
    }
}
