define(
    [
        'jquery',
        'ko',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Customer/js/model/customer',
        'Magento_Checkout/js/checkout-data',
    ],
    function (
        $,
        ko,
        Component,
        placeOrderAction,
        selectPaymentMethodAction,
        customer,
        checkoutData
    ) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'ZapperIntegration_Payments/payment/form',
            },

            config: function()
            {
                return window.checkoutConfig.payment[this.getCode()];
            },

            selectPaymentMethod: function() {
                selectPaymentMethodAction(this.getData());
                checkoutData.setSelectedPaymentMethod(this.item.method);
                return true;
            },

            isAvailable: function() {
                return !!this.config().available && quote.totals().grand_total <= 0;
            },

            isMethodAvailable: function() {

            },

            isMethodActive: function() {
                return window.checkoutConfig.payment[this.getCode()].enabled;
            },

            getCode: function()
            {
                return 'zapper';
            },

            placeOrder: async function (data, event) {
                if (event) {
                    event.preventDefault();
                }

                $.when(placeOrderAction(this.getData(), this.messageContainer))
                    .done(async () => {
                        const checkoutUrl = `${window.BASE_URL}zapper/payments/checkout`;
                        window.location.replace(checkoutUrl);
                    });

                return true;

            },
        });
    }
);
