<?php

namespace ZapperIntegration\Payments\Block;

use Magento\Framework\View\Element\Template;
use Magento\Payment\Model\MethodInterface;
use Psr\Log\LoggerInterface;

class Form extends \Magento\Payment\Block\Form
{


    public function __construct(Template\Context $context, array $data = [])
    {
        parent::__construct($context, $data);
    }




    /**
     * Retrieve payment method model
     *
     * @return MethodInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getMethod()
    {
        $method = $this->getData('method');

        if (!$method instanceof MethodInterface) {
            throw new \Magento\Framework\Exception\LocalizedException(
                __('We cannot retrieve the payment method model object.')
            );
        }
        return $method;
    }

    /**
     * Sets payment method instance to form
     *
     * @param MethodInterface $method
     * @return $this
     */
    public function setMethod(MethodInterface $method)
    {

        $this->setData('method', $method);
        return $this;
    }

    /**
     * Retrieve payment method code
     *
     * @return string
     */
    public function getMethodCode()
    {
        return $this->getMethod()->getCode();
    }



}
