<?php

namespace ZapperIntegration\Payments\Controller\Payments;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order;
use Magento\Store\Model\StoreManagerInterface;
use ZapperIntegration\Payments\Model\ZapperConstants;

class Complete implements HttpGetActionInterface
{
    private OrderRepositoryInterface $orderRepository;
    private RequestInterface $request;
    private ResultFactory $resultFactory;
    private ScopeConfigInterface $scopeConfig;
    private StoreManagerInterface $storeManager;

    /**
     * @param OrderRepositoryInterface $orderRepository
     * @param RequestInterface $request
     * @param ResultFactory $resultFactory
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(OrderRepositoryInterface $orderRepository, RequestInterface $request, ResultFactory $resultFactory, ScopeConfigInterface $scopeConfig, StoreManagerInterface $storeManager)
    {
        $this->orderRepository = $orderRepository;
        $this->request = $request;
        $this->resultFactory = $resultFactory;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface
     * @throws NoSuchEntityException
     */
    public function execute() : ResultInterface
    {
        $defaultStatus = Order::STATE_PROCESSING;

        if ($this->scopeConfig->isSetFlag(ZapperConstants::CONFIG_DEFAULT_STATUS)) {
            $defaultStatus = $this->scopeConfig->getValue(ZapperConstants::CONFIG_DEFAULT_STATUS);
        }

        $baseUrl = $this->storeManager->getStore()->getBaseUrl();
        $response = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $orderId = $this->request->getParam(ZapperConstants::ORDER_ID);

        if ($orderId == null) {
            $response->setUrl($baseUrl);
            return $response;
        }

        $order = $this->orderRepository->get($orderId);
        if ($order->getStatus() != $defaultStatus) {
            $response->setUrl($baseUrl);

            return $response;
        }

        $response->setUrl($baseUrl . "checkout/onepage/success");
        return $response;
    }
}
