<?php

namespace ZapperIntegration\Payments\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Payment\Gateway\Command\CommandPoolInterface;
use Magento\Payment\Gateway\Config\ValueHandlerPoolInterface;
use Magento\Payment\Gateway\Data\PaymentDataObjectFactory;
use Magento\Payment\Gateway\Validator\ValidatorPoolInterface;
use Magento\Payment\Model\Method\Adapter;

class PaymentMethod extends Adapter
{

    private ScopeConfigInterface $scopeConfig;

    public function __construct(

        ManagerInterface $eventManager,
        ValueHandlerPoolInterface $valueHandlerPool,
        PaymentDataObjectFactory $paymentDataObjectFactory,
        string $code,
        string $formBlockType,
        string $infoBlockType,
        ScopeConfigInterface $scopeConfig,
        CommandPoolInterface $commandPool = null,
        ValidatorPoolInterface $validatorPool = null
    )
    {
        parent::__construct(

            $eventManager,
            $valueHandlerPool,
            $paymentDataObjectFactory,
            $code,
            $formBlockType,
            $infoBlockType,
            $commandPool,
            $validatorPool
        );

        $this->scopeConfig = $scopeConfig;
    }

    public function isInitializeNeeded() : bool
    {
        return true;
    }

    public function isActive($storeId = null)
    {
        $isActive = $this->scopeConfig->getValue(ZapperConstants::CONFIG_ACTIVE);
        $credentialsVerified = $this->scopeConfig->getValue(ZapperConstants::CONFIG_VERIFIED);
        return $isActive && $credentialsVerified;
    }
}
