<?php

namespace ZapperIntegration\Payments\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use ZapperIntegration\Payments\Model\ZapperConstants;

class ConfigProvider implements ConfigProviderInterface
{
    const CODE = 'zapper';

    private ScopeConfigInterface $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function getConfig()
    {
        $active = $this->scopeConfig->getValue(ZapperConstants::CONFIG_ACTIVE);

        // TODO: Implement getConfig() method.
        return [
            'payment' => [
                self::CODE => [
                    'active' => $active,
                ]
            ]
        ];
    }
}
