<?php

namespace ZapperIntegration\Payments\Model;

class ZapperConstants
{
    // zapper fields
    public const ZAPPER_ID = "zapperId";
    public const ORDER_ID = "orderId";
    public const STATUS = "status";
    public const AMOUNT = "Amount";

    // configuration paths
    public const CONFIG_MERCHANT_ID = "payment/zapper_payments/merchantId";
    public const CONFIG_SITE_ID = "payment/zapper_payments/siteId";
    public const CONFIG_APIKEY = "payment/zapper_payments/apikey";
    public const CONFIG_DEFAULT_STATUS = "payment/zapper_payments/default_status";
    public const CONFIG_ACTIVE = "payment/zapper_payments/active";
    public const CONFIG_VERIFIED = "payment/zapper_payments/valid";

    // form fields
    public const FORM_MERCHANT_ID = "merchantId";
    public const FORM_MERCHANT_SITE_ID = "siteId";
    public const FORM_API_KEY = "apikey";

    // endpoints
    public const API_CANCEL = "zapper/payments/cancel";
    public const API_COMPLETE = "zapper/payments/complete";
    public const API_NOTIFICATION = "zapper/payments/notification";

    public const API_BASE_URL = "https://api.zapper.com/business";

    // integration
    public const ECOMMERCE_GATEWAY_TIMEOUT_SECONDS = 10;
    public const ECOMMERCE_GATEWAY_URL = "https://gateway.zapper.com/";

    public const ENV_VAR_ZAPPER_ECOM_GATEWAY = "ZAPPER_ECOMMERCE_GATEWAY";
    public const ENV_VAR_ZAPPER_BUSINESS_API = "ZAPPER_BUSINESS_API";
}
